--
-- bindSQLVariables.sql
--
DECLARE
  v_queryCtx  DBMS_XMLquery.ctxType;
  v_result    CLOB;
BEGIN
  v_queryCtx := DBMS_XMLQuery.newContext('SELECT * from EMPLOYEES 
                                          WHERE employee_id = :EMPLOYEE_ID
                                          AND first_name = :FIRST_NAME');

  DBMS_XMLQuery.setBindValue(v_queryCtx,'EMPLOYEE_ID',100);
  DBMS_XMLQuery.setBindValue(v_queryCtx,'FIRST_NAME','Steven');
  v_result := DBMS_XMLQuery.getXML(v_queryCtx);
  printClobOut(v_result); -- print the document

  DBMS_XMLQuery.setBindValue(v_queryCtx,'EMPLOYEE_ID',101);
  DBMS_XMLQuery.setBindValue(v_queryCtx,'FIRST_NAME','Neena');
  v_result := DBMS_XMLQuery.getXML(v_queryCtx);
  printClobOut(v_result); -- print the document
END;
/
